<?xml version="1.0" ?>
<!DOCTYPE layout [
 <!ENTITY baseResourcePath "/xang/apps/" >
 <!ENTITY nbsp "<![CDATA[ ]]>" >
 <!ENTITY tag-start "<![CDATA[<]]>" >
 <!ENTITY tag-end "<![CDATA[>]]>" >

 <!ENTITY atag-start "<xsl:text disable-output-escaping='yes'>&lt;</xsl:text>" >
 <!ENTITY atag-end "<xsl:text disable-output-escaping='yes'>&gt;</xsl:text>" >
]>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version='1.0' xml:space='false'>
<xsl:output method="html" indent="no"/>

<!-- the current 'root' -->
<xsl:template match='*' >
<HTML>
<BODY>
	<a href='.'>Refresh</a>
	<hr />
	
	<xsl:apply-templates select='..' mode='parent' />
	<xsl:apply-templates select='.' mode='nav'/>
	<xsl:apply-templates select='*' mode='child' />
	
</BODY>
</HTML>
</xsl:template>

<!-- &tag-start;DIV style="position:relative;top:0;left:8; display: ;"&tag-end; -->
<xsl:template match='*' mode='parent' >
	<xsl:choose>
	<xsl:when test='@name'>
		<xsl:apply-templates select='..' mode='parent' />
	</xsl:when>
	</xsl:choose>
	
	<xsl:text disable-output-escaping='yes'>
	&tag-start;DIV style="position:relative;top:0;left:8; display: ;"&tag-end;
	</xsl:text>
			
	<a target='_parent'>
	<xsl:attribute name='href'>
	<xsl:apply-templates select='.' mode='url'/>?do:method=editor
	</xsl:attribute>

	<img border='0' src="&baseResourcePath;images/folder.gif" /> &nbsp;
	<xsl:value-of select='@name' /> 
	</a>
</xsl:template>

<xsl:template match='*' mode='nav' >
	<xsl:if test='@name'>
			<xsl:text disable-output-escaping='yes'>
			&tag-start;DIV style="position:relative;top:0;left:8; display: ;"&tag-end;
			</xsl:text>
			
			<a target='_parent'>
			<xsl:attribute name='href'>./?do:method=editor</xsl:attribute>

			<img border='0' src="&baseResourcePath;images/folder.gif" /> &nbsp;
			<b><xsl:value-of select='@name' /> </b>
			</a>
			
	</xsl:if>
</xsl:template>

<xsl:template match='*' mode='child' >
	<xsl:if test='@name'>
			<xsl:text disable-output-escaping='yes'>
			&tag-start;DIV style="position:relative;top:0;left:8; display: ;"&tag-end;
			</xsl:text>
			
			<a target='_parent'>
			<xsl:attribute name='href'><xsl:value-of select='@name' />/?do:method=editor</xsl:attribute>

			<img border='0' src="&baseResourcePath;images/folder.gif" /> &nbsp;
			<xsl:value-of select='@name' /> 
			</a>
			<xsl:text disable-output-escaping='yes'>
			&tag-start;/DIV&tag-end;
			</xsl:text>
	</xsl:if>
</xsl:template>

<xsl:template match='*' mode='url'>
<xsl:choose>
	<xsl:when test='@name'>
		../<xsl:apply-templates select='..' mode='url'/>
	</xsl:when>
	<xsl:otherwise></xsl:otherwise>
</xsl:choose>
</xsl:template>

</xsl:stylesheet>
