/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.net.http.object.impl;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xang.net.http.object.IHTTPAuthorizationInfo;
import org.apache.xang.net.http.object.IHTTPContext;
import org.apache.xang.net.http.object.IHTTPObjectSystem;
import org.apache.xang.net.http.object.impl.auth.HTTPCertAuthorizationHandlerFactory;
import org.apache.xang.net.http.object.impl.auth.IHTTPAuthorizationAdder;
import org.apache.xang.net.http.object.impl.auth.IHTTPAuthorizationHandler;
import org.apache.xang.net.http.object.impl.auth.IHTTPCertAuthorizationConstants;

public class HTTPContext
implements IHTTPContext,
IHTTPCertAuthorizationConstants {
    private HTTPCertAuthorizationHandlerFactory authFactory = new HTTPCertAuthorizationHandlerFactory();
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext servletContext;
    private IHTTPAuthorizationInfo authInfo;
    private IHTTPObjectSystem objectSystem;
    private static Vector authExtractors = new Vector();
    private static Vector authInjectors = new Vector();
    public static final String RCS_STRING = "$Workfile: HTTPContext.java $ $Revision: 1.2 $";

    HTTPContext() {
    }

    HTTPContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.init(request, response, servletContext);
    }

    void trace(String s) {
        System.out.println(s);
    }

    protected static void initAuthExtractors(Properties props) {
        int i = 0;
        while (i < 100) {
            String prop = "auth." + i + ".name";
            String name = props.getProperty(prop);
            prop = "auth." + i + ".class";
            String classname = props.getProperty(prop);
            if (name == null || classname == null) break;
            Hashtable<String, Object> values = new Hashtable<String, Object>();
            values.put("name", name);
            values.put("class", classname);
            try {
                IHTTPAuthorizationHandler authHandler;
                Class<?> authClass = Class.forName(classname);
                if (authClass == null || (authHandler = (IHTTPAuthorizationHandler)authClass.newInstance()) == null) break;
                values.put("instance", authHandler);
                authExtractors.addElement(values);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    protected static void initAuthInjectors(Properties props) {
        int i = 0;
        while (i < 100) {
            String prop = "auth.adder." + i + ".name";
            String name = props.getProperty(prop);
            prop = "auth.adder." + i + ".class";
            String classname = props.getProperty(prop);
            if (name == null || classname == null) break;
            Hashtable<String, Object> values = new Hashtable<String, Object>();
            values.put("name", name);
            values.put("class", classname);
            try {
                IHTTPAuthorizationAdder authHandler;
                Class<?> authClass = Class.forName(classname);
                if (authClass == null || (authHandler = (IHTTPAuthorizationAdder)authClass.newInstance()) == null) break;
                values.put("instance", authHandler);
                authInjectors.addElement(values);
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public static void initSystem(Properties props) {
        HTTPContext.initAuthExtractors(props);
        HTTPContext.initAuthInjectors(props);
    }

    public void init(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public IHTTPAuthorizationInfo getAuthInfo() {
        IHTTPAuthorizationHandler handler = null;
        if (this.authInfo != null) {
            return this.authInfo;
        }
        if (this.request == null) {
            return null;
        }
        int i = 0;
        while (i < authExtractors.size()) {
            Hashtable values = (Hashtable)authExtractors.elementAt(i);
            handler = (IHTTPAuthorizationHandler)values.get("instance");
            if (handler != null && handler.canService(this.request)) {
                this.authInfo = handler.getAuthInfo(this.request);
                if (this.authInfo != null) break;
            }
            ++i;
        }
        return this.authInfo;
    }

    public void addAuthInfo(IHTTPAuthorizationInfo info) {
        IHTTPAuthorizationAdder handler = null;
        int i = 0;
        while (i < authInjectors.size()) {
            Hashtable values = (Hashtable)authInjectors.elementAt(i);
            handler = (IHTTPAuthorizationAdder)values.get("instance");
            if (handler != null) {
                handler.addAuthInfo(info, this.request, this.response);
            }
            ++i;
        }
    }

    public String addAuthInfoToURL(IHTTPAuthorizationInfo info, String url) {
        IHTTPAuthorizationAdder handler = null;
        String newUrl = url;
        int i = 0;
        while (i < authInjectors.size()) {
            Hashtable values = (Hashtable)authInjectors.elementAt(i);
            handler = (IHTTPAuthorizationAdder)values.get("instance");
            if (handler != null) {
                newUrl = handler.addAuthInfoToURL(info, this.request, this.response, newUrl);
            }
            ++i;
        }
        return newUrl;
    }

    public void setHTTPObjectSystem(IHTTPObjectSystem objectSystem) {
        this.objectSystem = objectSystem;
    }

    public IHTTPObjectSystem getHTTPObjectSystem() {
        return this.objectSystem;
    }
}

