/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.net.http.object.impl.auth.certificate.client_cert_subject_dn;

import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.xang.net.http.object.IHTTPAuthorizationInfo;
import org.apache.xang.net.http.object.impl.HTTPAuthInfo;
import org.apache.xang.net.http.object.impl.auth.IHTTPAuthorizationHandler;
import org.apache.xang.net.http.object.impl.auth.IHTTPCertAuthorizationConstants;

public class AuthHandler
implements IHTTPAuthorizationHandler,
IHTTPCertAuthorizationConstants {
    private static final String AUTH_HEADER = "CLIENT_CERT_SUBJECT_DN";
    private static final String AUTH_TYPE = "CERT_AUTH_NETSCAPE_LDAP_NT";
    public static final String RCS_STRING = "$Workfile: AuthHandler.java $ $Revision: 1.2 $";

    protected String getUserName(String credentials) {
        return this.getSubjectField(credentials, "UserID=");
    }

    protected String getUserRealm(String credentials) {
        return this.getSubjectField(credentials, "O=");
    }

    protected String getSubjectField(String subject, String fieldName) {
        StringBuffer certTokens = new StringBuffer(128);
        if (subject != null) {
            StringTokenizer st = new StringTokenizer(subject, ",");
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                if (tk.charAt(0) == ' ') {
                    tk = tk.substring(1);
                }
                if (!tk.startsWith(fieldName, 0)) continue;
                certTokens.append(tk.substring(fieldName.length()));
                break;
            }
        }
        return certTokens.toString();
    }

    protected String getAuthenticationType() {
        return AUTH_TYPE;
    }

    protected boolean setLdapInfo(String ldapAddr, String startSearch, String filter) {
        return false;
    }

    public boolean canService(HttpServletRequest req) {
        return req.getHeader(AUTH_HEADER) != null;
    }

    public IHTTPAuthorizationInfo getAuthInfo(String credentials) {
        HTTPAuthInfo info = new HTTPAuthInfo();
        info.setValue("certificate", "true");
        info.setValue("authType", this.getAuthenticationType());
        info.setValue("username", this.getUserName(credentials));
        info.setValue("domain", this.getUserRealm(credentials));
        info.setValue("distinguishedName", credentials);
        return info;
    }

    public IHTTPAuthorizationInfo getAuthInfo(HttpServletRequest req) {
        String credentials = req.getHeader(AUTH_HEADER);
        IHTTPAuthorizationInfo info = this.getAuthInfo(credentials);
        return info;
    }
}

