/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.scriptEngine;

import FESI.jslib.JSException;
import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSUtil;
import org.apache.xang.scriptEngine.IEngine;

public class FesiEngine
implements IEngine {
    public static final String[] FESI_EXTENSIONS = new String[]{"FESI.Extensions.BasicIO", "FESI.Extensions.JavaAccess"};
    public JSGlobalObject jsObject;
    protected String script;
    protected Exception lastError;

    public FesiEngine() {
        try {
            this.jsObject = JSUtil.makeEvaluator((String[])FESI_EXTENSIONS);
        }
        catch (JSException e) {
            this.lastError = e;
        }
    }

    public void addNamedObject(String name, Object object) {
        try {
            if (object != null) {
                this.jsObject.makeObjectWrapper(object);
            }
            this.jsObject.setMember(name, object);
        }
        catch (JSException e) {
            this.lastError = e;
        }
    }

    public void addScript(String script) {
        this.script = script;
    }

    public boolean run(String method) {
        try {
            Object result = this.jsObject.evalAsFunction(String.valueOf(method) + this.script);
        }
        catch (Exception e) {
            this.lastError = e;
            return false;
        }
        return true;
    }

    public Exception getLastError() {
        return this.lastError;
    }
}

