/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.xap.xml;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.xang.xap.XapDebug;
import org.apache.xang.xap.xml.DynamicDocData;
import org.apache.xang.xap.xml.DynamicDocumentParser;
import org.apache.xang.xap.xml.IXMLLinker;
import org.apache.xang.xap.xml.NodeListImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.NodeImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DynamicDocument
extends DocumentImpl {
    public static final String INCLUDE_TAG = "include";
    public static final String SOURCE_TAG = "src";
    public static final String XML_LINK_TAG = "xml:link";
    public static final String FACTORY_SELECT_TAG = "//*[@xml:link='java' $and$ @factory]";
    public static final String FACTORY_TAG = "factory";
    public static final String INCLUDE_SELECT_TAG = "//*[@xml:link='include']";
    public static final String NODEFROMID_SELECT_TAG_ONE = "*[@name='";
    public static final String NODEFROMID_SELECT_TAG_TWO = "']";
    boolean preserveWhitespace;
    Hashtable dynamicDocs;

    public DynamicDocument(boolean validate, boolean preserveWhitespace) {
        this.preserveWhitespace = preserveWhitespace;
        ((NodeImpl)this).ownerDocument = this;
    }

    public static void trace(String s) {
        XapDebug.out(s);
    }

    public void load(String url) {
        this.dynamicDocs = new Hashtable();
        try {
            this.doLoad(url);
        }
        catch (Exception e) {
            XapDebug.out("DynamicDocument.load(): EXCEPTION: Unable to load " + url + "\n" + e.getMessage());
        }
    }

    public boolean shouldReload() {
        if (this.dynamicDocs.size() < 1) {
            return true;
        }
        Enumeration docDataEnum = this.dynamicDocs.elements();
        while (docDataEnum.hasMoreElements()) {
            DynamicDocData docData = (DynamicDocData)docDataEnum.nextElement();
            if (!docData.shouldReload()) continue;
            try {
                if (docData.isRoot) {
                    return true;
                }
                docData.reload(this.dynamicDocs);
            }
            catch (Exception e) {
                XapDebug.error(e);
                return true;
            }
        }
        return false;
    }

    private NodeList findFactories(Element root) {
        NodeListImpl includes = new NodeListImpl();
        Node node = root.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                NodeList list;
                Element child = (Element)node;
                if ("java".equals(child.getAttribute(XML_LINK_TAG)) && child.getAttributeNode(FACTORY_TAG) != null) {
                    includes.addNode(node);
                }
                if ((list = this.findFactories(child)) != null) {
                    int i = 0;
                    while (i < list.getLength()) {
                        includes.addNode(list.item(i));
                        ++i;
                    }
                }
            }
            node = node.getNextSibling();
        }
        return includes;
    }

    public void loadPlugIns() {
        Element root = this.getDocumentElement();
        NodeList plugInList = this.findFactories(root);
        int plugInListLength = plugInList.getLength();
        int index = 0;
        while (index < plugInListLength) {
            Element plugInNode = (Element)plugInList.item(index);
            String classFactory = plugInNode.getAttribute(FACTORY_TAG);
            try {
                Class<?> newClass = Class.forName(classFactory);
                Object obj = newClass.newInstance();
                IXMLLinker linker = (IXMLLinker)obj;
                linker.loadElement(plugInNode);
            }
            catch (Exception e) {
                System.err.println("EXCEPTION: Unable to load " + classFactory);
                XapDebug.error(e);
            }
            ++index;
        }
    }

    public static String makeUrl(String base, String other) {
        int pos;
        String path = null;
        other = other.replace('\\', '/');
        base = base.replace('\\', '/');
        if (other.indexOf(58) >= 0) {
            return other;
        }
        File baseFile = new File(base);
        if (baseFile.exists() && baseFile.isFile() && (pos = base.lastIndexOf("/")) > 0) {
            base = base.substring(0, pos);
        }
        path = base.endsWith("/") ? (other.startsWith("/") ? String.valueOf(base) + other.substring(1, other.length()) : String.valueOf(base) + other) : (other.startsWith("/") ? String.valueOf(base) + other : String.valueOf(base) + "/" + other);
        return path;
    }

    public static synchronized DynamicDocData addToMasterDocHash(String url, Node node, Hashtable masterDocHash) {
        DynamicDocData docData = (DynamicDocData)masterDocHash.get(url);
        if (docData == null) {
            docData = new DynamicDocData(url);
            masterDocHash.put(url, docData);
        }
        docData.nodes.addElement(node);
        return docData;
    }

    public static boolean alreadyInStack(String url, Stack includeStack) {
        return includeStack.contains(url);
    }

    private NodeList findIncludes(Element root) {
        NodeListImpl includes = new NodeListImpl();
        Node node = root.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                NodeList list;
                Element child = (Element)node;
                if (INCLUDE_TAG.equals(child.getAttribute(XML_LINK_TAG))) {
                    includes.addNode(node);
                }
                if ((list = this.findIncludes(child)) != null) {
                    int i = 0;
                    while (i < list.getLength()) {
                        includes.addNode(list.item(i));
                        ++i;
                    }
                }
            }
            node = node.getNextSibling();
        }
        return includes;
    }

    public static void swapNodes(Node target, Node source) {
        Node parent = target.getParentNode();
        DocumentImpl doc = (DocumentImpl)target.getOwnerDocument();
        Node newNode = doc.importNode(source, true);
        parent.replaceChild(newNode, target);
    }

    public void doLoad(String url) throws Exception {
        this.dynamicDocs = new Hashtable();
        Stack<String> includeStack = new Stack<String>();
        includeStack.addElement(url);
        DynamicDocumentParser parser = new DynamicDocumentParser(this);
        parser.parse(url);
        DynamicDocData rootDoc = DynamicDocument.addToMasterDocHash(url, this.getDocumentElement(), this.dynamicDocs);
        rootDoc.isRoot = true;
        this.loadIncludes(url, includeStack);
        this.loadPlugIns();
    }

    protected void loadIncludes(String url, Stack includeStack) throws Exception {
        NodeList includeList = this.findIncludes(this.getDocumentElement());
        if (includeList != null) {
            DynamicDocument.trace("DynamicDocument.doLoad(): Found " + includeList.getLength() + " XLINK links in " + url);
            int includeListLength = includeList.getLength();
            int index = 0;
            while (index < includeListLength) {
                Node includeNode = includeList.item(index);
                Node srcNode = includeNode.getAttributes().getNamedItem(SOURCE_TAG);
                String childUrl = srcNode.getNodeValue();
                if ((childUrl = DynamicDocument.makeUrl(url, childUrl)) != null) {
                    if (DynamicDocument.alreadyInStack(childUrl, includeStack)) {
                        throw new Exception("Circular reference during include: " + childUrl);
                    }
                    includeStack.push(childUrl);
                    DynamicDocument importDoc = new DynamicDocument(false, false);
                    importDoc.doLoad(childUrl, this.dynamicDocs, includeStack);
                    DynamicDocument.swapNodes(includeNode, importDoc.getDocumentElement());
                    DynamicDocument.addToMasterDocHash(childUrl, importDoc.getDocumentElement(), this.dynamicDocs);
                    includeStack.pop();
                }
                ++index;
            }
        }
    }

    public void doLoad(String url, Hashtable dynamicDocHash, Stack includeStack) throws Exception {
        this.load(url);
        this.loadIncludes(url, includeStack);
    }
}

