/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.util;

import java.util.Enumeration;
import java.util.Hashtable;

public class TextUtil {
    public static String encodeToHTML(String unencodedText) {
        char b;
        char suspect;
        if (unencodedText == null) {
            return null;
        }
        boolean bNeedsWork = false;
        int length = unencodedText.length();
        int i = 0;
        while (i < length) {
            suspect = unencodedText.charAt(i);
            b = suspect;
            if (b > '\u007f') {
                bNeedsWork = true;
                break;
            }
            switch (suspect) {
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    bNeedsWork = true;
                    break;
                }
            }
            if (bNeedsWork) break;
            ++i;
        }
        if (!bNeedsWork) {
            return unencodedText;
        }
        StringBuffer out = new StringBuffer(length + 16);
        int i2 = 0;
        while (i2 < length) {
            suspect = unencodedText.charAt(i2);
            b = suspect;
            if (b > '\u007f') {
                out.append("&#" + Integer.toString(b) + ";");
            } else {
                switch (suspect) {
                    case '\"': {
                        out.append("&quot;");
                        break;
                    }
                    case '&': {
                        out.append("&amp;");
                        break;
                    }
                    case '<': {
                        out.append("&lt;");
                        break;
                    }
                    case '>': {
                        out.append("&gt;");
                        break;
                    }
                    default: {
                        out.append(suspect);
                        break;
                    }
                }
            }
            ++i2;
        }
        return out.toString();
    }

    public static String encodeToHTMLWithinJS(String str) {
        char[] in = str.toCharArray();
        int len = in.length;
        boolean noEscape = true;
        int i = 0;
        while (i < len) {
            char c = in[i];
            if (c == '\"' || c == '\'' || c == '\\' || c == '\r' || c == '\n' || c == '\t' || c == '&' || c == '<' || c == '>') {
                noEscape = false;
                break;
            }
            ++i;
        }
        if (noEscape) {
            return str;
        }
        StringBuffer b = new StringBuffer(len + 8);
        int i2 = 0;
        while (i2 < len) {
            char c = in[i2];
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    b.append('\\').append(c);
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '>': {
                    b.append("&gt;");
                    break;
                }
                default: {
                    b.append(c);
                    break;
                }
            }
            ++i2;
        }
        return b.toString();
    }

    public static String encodeToJS(String str) {
        char[] in = str.toCharArray();
        int len = in.length;
        boolean noEscape = true;
        int i = 0;
        while (i < len) {
            char c = in[i];
            if (c == '\"' || c == '\'' || c == '\\' || c == '\r' || c == '\n' || c == '\t') {
                noEscape = false;
                break;
            }
            ++i;
        }
        if (noEscape) {
            return str;
        }
        StringBuffer b = new StringBuffer(len + 8);
        int i2 = 0;
        while (i2 < len) {
            char c = in[i2];
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    b.append('\\').append(c);
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                default: {
                    b.append(c);
                    break;
                }
            }
            ++i2;
        }
        return b.toString();
    }

    public static String encodeToPreTransformationHTML(String unencodedText) {
        char b;
        char suspect;
        if (unencodedText == null) {
            return null;
        }
        boolean bNeedsWork = false;
        int length = unencodedText.length();
        int i = 0;
        while (i < length) {
            suspect = unencodedText.charAt(i);
            b = suspect;
            if (b > '\u007f') {
                bNeedsWork = true;
                break;
            }
            switch (suspect) {
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    bNeedsWork = true;
                    break;
                }
            }
            if (bNeedsWork) break;
            ++i;
        }
        if (!bNeedsWork) {
            return unencodedText;
        }
        StringBuffer out = new StringBuffer(length + 16);
        int i2 = 0;
        while (i2 < length) {
            suspect = unencodedText.charAt(i2);
            b = suspect;
            if (b > '\u007f') {
                out.append("&#" + Integer.toString(b) + ";");
            } else {
                switch (suspect) {
                    case '\"': {
                        i2 = TextUtil.escapeSpacesAroundEscapedChar(unencodedText, out, i2, "&#34;");
                        break;
                    }
                    case '&': {
                        i2 = TextUtil.escapeSpacesAroundEscapedChar(unencodedText, out, i2, "&#38;");
                        break;
                    }
                    case '<': {
                        i2 = TextUtil.escapeSpacesAroundEscapedChar(unencodedText, out, i2, "&#60;");
                        break;
                    }
                    case '>': {
                        i2 = TextUtil.escapeSpacesAroundEscapedChar(unencodedText, out, i2, "&#62;");
                        break;
                    }
                    default: {
                        out.append(suspect);
                        break;
                    }
                }
            }
            ++i2;
        }
        return out.toString();
    }

    public static String encodeToXML(String unencodedText) {
        char b;
        char suspect;
        if (unencodedText == null) {
            return null;
        }
        boolean bNeedsWork = false;
        int length = unencodedText.length();
        int i = 0;
        while (i < length) {
            suspect = unencodedText.charAt(i);
            b = suspect;
            if (b > '\u007f') {
                bNeedsWork = true;
                break;
            }
            switch (suspect) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    bNeedsWork = true;
                    break;
                }
            }
            if (bNeedsWork) break;
            ++i;
        }
        if (!bNeedsWork) {
            return unencodedText;
        }
        StringBuffer out = new StringBuffer(length + 16);
        int i2 = 0;
        while (i2 < length) {
            suspect = unencodedText.charAt(i2);
            b = suspect;
            if (b > '\u007f') {
                out.append("&#" + Integer.toString(b) + ";");
            } else {
                switch (suspect) {
                    case '\"': {
                        out.append("&quot;");
                        break;
                    }
                    case '\'': {
                        out.append("&apos;");
                        break;
                    }
                    case '&': {
                        out.append("&amp;");
                        break;
                    }
                    case '<': {
                        out.append("&lt;");
                        break;
                    }
                    case '>': {
                        out.append("&gt;");
                        break;
                    }
                    default: {
                        out.append(suspect);
                        break;
                    }
                }
            }
            ++i2;
        }
        return out.toString();
    }

    public static String encodeToXQL(String unencodedText) {
        char suspect;
        if (unencodedText == null) {
            return null;
        }
        boolean bNeedsWork = false;
        int length = unencodedText.length();
        int i = 0;
        while (i < length) {
            suspect = unencodedText.charAt(i);
            switch (suspect) {
                case '\"': 
                case '\'': 
                case '\\': {
                    bNeedsWork = true;
                    break;
                }
            }
            if (bNeedsWork) break;
            ++i;
        }
        if (!bNeedsWork) {
            return unencodedText;
        }
        StringBuffer out = new StringBuffer();
        length = unencodedText.length();
        int i2 = 0;
        while (i2 < length) {
            suspect = unencodedText.charAt(i2);
            switch (suspect) {
                case '\\': {
                    out.append("\\\\");
                    break;
                }
                case '\"': {
                    out.append("\\\"");
                    break;
                }
                case '\'': {
                    out.append("\\'");
                    break;
                }
                default: {
                    out.append(suspect);
                    break;
                }
            }
            ++i2;
        }
        return out.toString();
    }

    public static String encodeToXQLString(String unencodedText) {
        char b;
        char suspect;
        if (unencodedText == null) {
            return null;
        }
        boolean bNeedsWork = false;
        int length = unencodedText.length();
        int i = 0;
        while (i < length) {
            suspect = unencodedText.charAt(i);
            b = suspect;
            if (b > '\u007f') {
                bNeedsWork = true;
                break;
            }
            switch (suspect) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': 
                case '\\': {
                    bNeedsWork = true;
                    break;
                }
            }
            if (bNeedsWork) break;
            ++i;
        }
        if (!bNeedsWork) {
            return unencodedText;
        }
        StringBuffer out = new StringBuffer();
        length = unencodedText.length();
        int i2 = 0;
        while (i2 < length) {
            suspect = unencodedText.charAt(i2);
            b = suspect;
            if (b > '\u007f') {
                out.append("&#" + Integer.toString(b) + ";");
            } else {
                switch (suspect) {
                    case '&': {
                        out.append("&amp;");
                        break;
                    }
                    case '<': {
                        out.append("&lt;");
                        break;
                    }
                    case '>': {
                        out.append("&gt;");
                        break;
                    }
                    case '\\': {
                        out.append("\\\\");
                        break;
                    }
                    case '\"': {
                        out.append("\\&quot;");
                        break;
                    }
                    case '\'': {
                        out.append("\\&apos;");
                        break;
                    }
                    default: {
                        out.append(suspect);
                        break;
                    }
                }
            }
            ++i2;
        }
        return out.toString();
    }

    protected static int escapeSpacesAroundEscapedChar(String unencodedText, StringBuffer encodedText, int pos, String escapedChar) {
        int returnPos = pos;
        if (pos > 0 && unencodedText.charAt(pos - 1) == ' ') {
            encodedText.setCharAt(encodedText.length() - 1, '&');
            encodedText.append("#32;");
        }
        encodedText.append(escapedChar);
        if (pos < unencodedText.length() - 1 && unencodedText.charAt(pos + 1) == ' ') {
            encodedText.append("&#32;");
            ++returnPos;
        }
        return returnPos;
    }

    public static String formatXML(String xml) {
        StringBuffer fxml = new StringBuffer();
        boolean fwaitForEnd = false;
        int i = 0;
        while (i < xml.length()) {
            char chr = xml.charAt(i);
            fxml.append(chr);
            if (fwaitForEnd) {
                if (chr == '>') {
                    fxml.append("\n");
                }
            } else if (chr == '/') {
                fwaitForEnd = true;
            }
            ++i;
        }
        return fxml.toString();
    }

    public static String replaceAll(String text, String find, String replace) {
        int replaceLen = replace.length();
        int index = text.indexOf(find);
        while (index >= 0) {
            text = String.valueOf(text.substring(0, index)) + replace + text.substring(index + find.length());
            index = text.indexOf(find, index + replaceLen);
        }
        return text;
    }

    public static String replaceEntityRefs(String text, Hashtable values) {
        String newString = text;
        if (text.indexOf("&") >= 0) {
            Enumeration keys = values.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)values.get(key);
                newString = TextUtil.replaceAll(newString, "&" + key + ";", value);
            }
        }
        return newString;
    }
}

