/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.xap;

import org.apache.xang.net.http.object.IHTTPContext;
import org.apache.xang.net.http.object.impl.HTTPScriptContext;
import org.apache.xang.net.http.object.impl.HTTPScriptedObject;
import org.apache.xang.scriptEngine.EngineFactory;
import org.apache.xang.scriptEngine.IEngine;
import org.apache.xang.xap.XapDebug;
import org.apache.xang.xap.XapSystem;
import org.apache.xang.xap.xml.NodeListImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XapScript
extends HTTPScriptedObject {
    public static final String XML_TAG = "xml";
    public static final String SCRIPT_TAG = "script";
    public static final String RETURNTYPES_TAG = "returnTypes";
    XapSystem root;
    Element element;
    String defaultLanguage;
    public static final String RCS_STRING = "$Workfile: XapScript.java $ $Revision: 1.2 $";

    public XapScript(XapSystem root, Element element) {
        this.root = root;
        this.element = element;
        this.defaultLanguage = "javascript";
    }

    protected String _loadHandler(String function, Element element) {
        int pos;
        Element node = this.getHandlerElement(function, element);
        if (node == null) {
            return null;
        }
        String buffer = node.getAttribute(function);
        if (buffer != null && (pos = buffer.indexOf(58)) > 0) {
            buffer = buffer.substring(pos + 1);
        }
        return buffer;
    }

    protected String _loadHandlerType(String function, Element element) {
        Element node = this.getHandlerElement(function, element);
        if (node == null) {
            return null;
        }
        String handler = node.getAttribute(function);
        int pos = handler.indexOf(58);
        handler = pos > 0 ? handler.substring(0, pos) : null;
        if (handler == null || handler.equals("")) {
            handler = node.getAttribute("xap:language");
        }
        return handler;
    }

    protected String _loadScript(String language, Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Element currentNode = element;
        while (currentNode != null) {
            NodeList scriptList = this.getScripts(currentNode);
            int listLength = scriptList.getLength();
            int i = 0;
            while (i < listLength) {
                Element script = (Element)scriptList.item(i);
                if (script != null) {
                    String scriptLanguage = script.getAttribute("xap:language");
                    if (scriptLanguage == null) {
                        scriptLanguage = this.defaultLanguage;
                    }
                    if (language == null || language.equalsIgnoreCase(scriptLanguage)) {
                        if (this.scriptType == -1) {
                            this.scriptType = EngineFactory.scriptType(script.getAttribute("Language"));
                        }
                        buffer.insert(0, String.valueOf(this.getNodeValue(script)) + '\n');
                    }
                }
                ++i;
            }
            if (currentNode.getParentNode().getNodeType() != 1) break;
            currentNode = (Element)currentNode.getParentNode();
        }
        return buffer.toString();
    }

    public Object createObject(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            XapDebug.error(e);
            return null;
        }
    }

    public Element getElement() {
        return this.element;
    }

    protected Element getHandlerElement(String function, Element element) {
        Element currentNode = element;
        while (currentNode != null) {
            String buffer = currentNode.getAttribute(function);
            if (buffer != null && buffer.length() > 0) {
                return currentNode;
            }
            Node parent = currentNode.getParentNode();
            if (parent != null && parent.getNodeType() != 1) break;
            currentNode = (Element)currentNode.getParentNode();
        }
        return null;
    }

    protected String getNodeValue(Element element) {
        StringBuffer buffer = new StringBuffer();
        Node node = element.getFirstChild();
        while (node != null) {
            String value = node.getNodeValue();
            if (value != null) {
                buffer.append(value);
            }
            node = node.getNextSibling();
        }
        return buffer.toString();
    }

    protected NodeList getScripts(Element root) {
        NodeListImpl scripts = new NodeListImpl();
        Node node = root.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && SCRIPT_TAG.equals(node.getNodeName())) {
                scripts.addNode(node);
            }
            node = node.getNextSibling();
        }
        return scripts;
    }

    public XapSystem getSystem() {
        return this.root;
    }

    public void initSourceContext(IEngine engine) {
        super.initSourceContext(engine);
        engine.addNamedObject(XML_TAG, this.element);
    }

    public String loadHandler(String function) {
        return this._loadHandler(function, this.element);
    }

    public String loadHandlerType(String function) {
        return this._loadHandlerType(function, this.element);
    }

    public String loadScript(String language) {
        return this._loadScript(language, this.element);
    }

    public boolean onError(Throwable error, HTTPScriptContext scriptContext) {
        return super.onError(error, scriptContext);
    }

    public void out(IHTTPContext context, String message) {
        try {
            context.getResponse().getWriter().println(message);
        }
        catch (Exception e) {
            XapDebug.error(e);
        }
    }
}

