/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.net.http.object.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xang.net.http.object.IHTTPContext;
import org.apache.xang.net.http.object.IHTTPObject;
import org.apache.xang.net.http.object.impl.HTTPObjectServer;

public class HTTPObject
implements IHTTPObject {
    private static Class[] paramSignature;
    public static final String RCS_STRING = "$Workfile: HTTPObject.java $ $Revision: 1.3 $";

    protected static void trace(String s) {
        System.out.println(s);
    }

    public static boolean dispatchToObject(IHTTPObject object, IHTTPContext context, Vector returnTypes, String method, Hashtable parameters) {
        try {
            if (paramSignature == null) {
                System.out.println("paramSig == null");
            }
            method = method.toLowerCase();
            Method meth = object.getClass().getMethod(method, paramSignature);
            Object[] args = new Object[]{context, returnTypes, method, parameters};
            Boolean bool = (Boolean)meth.invoke((Object)object, args);
            return bool;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("HTTPObject.dispatch(): EXCEPTION: No such method '" + method + "' in " + object.getClass().getName());
        }
        catch (InvocationTargetException te) {
            System.out.println("HTTPObject.dispatch(): EXCEPTION: Invocation target exception. " + te.getTargetException().getMessage());
            System.out.println("\t\t in method '" + method + "' of " + object.getClass().getName());
            te.getTargetException().printStackTrace(System.out);
        }
        catch (Exception e) {
            System.out.println("HTTPObject.dispatch(): EXCEPTION: " + e.getMessage());
            System.out.println("\t\t in method '" + method + "' of " + object.getClass().getName());
        }
        return false;
    }

    public static boolean hasMimeType(Vector types, String type) {
        boolean found = false;
        if (types == null) {
            return false;
        }
        int i = 0;
        while (i < types.size()) {
            if (((String)types.elementAt(i)).startsWith(type)) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    public static boolean redirectTo(IHTTPContext context, String url) {
        try {
            context.getResponse().sendRedirect(url);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean redirectToSelf(IHTTPContext context) {
        try {
            context.getResponse().sendRedirect(HTTPObjectServer.makeURL(context.getRequest(), context.getRequest().getPathInfo()));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean redirectToParent(IHTTPContext context) {
        try {
            context.getResponse().sendRedirect(HTTPObjectServer.makeParentURL(context.getRequest(), context.getRequest().getPathInfo()));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void sendAuthenticate(IHTTPContext context, String authType, String realm) {
        context.getResponse().setHeader("WWW-Authenticate", String.valueOf(authType) + " realm=\"" + realm + "\"");
        context.getResponse().setStatus(401, "Login required.");
    }

    public boolean dispatch(IHTTPContext context, Vector returnTypes, String method, Hashtable parameters) {
        return HTTPObject.dispatchToObject(this, context, returnTypes, method, parameters);
    }

    public IHTTPObject getChild(Vector idPath, int startingOffset) {
        return this;
    }

    public void releaseChild(IHTTPObject child) {
    }

    public static void printModifierStrings(StringBuffer sb, int modifiers) {
        if (Modifier.isAbstract(modifiers)) {
            sb.append(" abstract='true'");
        }
        if (Modifier.isFinal(modifiers)) {
            sb.append(" final='true'");
        }
        if (Modifier.isInterface(modifiers)) {
            sb.append(" interface='true'");
        }
        if (Modifier.isNative(modifiers)) {
            sb.append(" native='true'");
        }
        if (Modifier.isPrivate(modifiers)) {
            sb.append(" private='true'");
        }
        if (Modifier.isProtected(modifiers)) {
            sb.append(" protected='true'");
        }
        if (Modifier.isPublic(modifiers)) {
            sb.append(" public='true'");
        }
        if (Modifier.isStatic(modifiers)) {
            sb.append(" static='true'");
        }
        if (Modifier.isSynchronized(modifiers)) {
            sb.append(" synchronized='true'");
        }
        if (Modifier.isTransient(modifiers)) {
            sb.append(" transient='true'");
        }
        if (Modifier.isVolatile(modifiers)) {
            sb.append(" volatile='true'");
        }
    }

    public static void doListMethods(StringBuffer sb, Class info) {
        Class<?>[] parameterTypes = null;
        Method[] methods = null;
        Method method = null;
        int modifiers = 0;
        String className = info.getName();
        methods = info.getMethods();
        int i = 0;
        while (i < methods.length) {
            method = methods[i];
            String name = method.getName();
            Class<?> retType = method.getReturnType();
            parameterTypes = method.getParameterTypes();
            modifiers = method.getModifiers();
            sb.append("<method");
            sb.append(" name='" + name + "'");
            if (!method.getDeclaringClass().getName().equalsIgnoreCase(className)) {
                sb.append(" from='" + method.getDeclaringClass().getName() + "'");
            }
            HTTPObject.printModifierStrings(sb, method.getModifiers());
            sb.append(">\n");
            sb.append("\t<return type='" + retType.getName() + "'");
            HTTPObject.printModifierStrings(sb, retType.getModifiers());
            sb.append("/>\n");
            int j = 0;
            while (j < parameterTypes.length) {
                sb.append("\t<parameter type='" + parameterTypes[j].getName() + "'");
                HTTPObject.printModifierStrings(sb, parameterTypes[j].getModifiers());
                sb.append("/>\n");
                ++j;
            }
            sb.append("</method>\n");
            ++i;
        }
    }

    public static void doGetClassMetadata(StringBuffer sb, Class info) {
        String className = info.getName();
        sb.append("<class name='" + className + "' ");
        HTTPObject.printModifierStrings(sb, info.getModifiers());
        sb.append(">\n");
    }

    public static String doDiscovery(Class info) {
        String htmlOutput = null;
        try {
            StringBuffer sb = new StringBuffer();
            String className = info.getName();
            HTTPObject.doGetClassMetadata(sb, info);
            HTTPObject.doListMethods(sb, info);
            sb.append("</class>");
            htmlOutput = sb.toString();
        }
        catch (Exception e) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            e.printStackTrace(ps);
            htmlOutput = "<html><body>Class2Xml.doDiscovery() : EXCEPTION: " + e.getMessage() + "<br/>" + baos.toString() + "</body></html>";
        }
        return htmlOutput;
    }

    public static String doDiscovery(String className) {
        String htmlOutput = null;
        try {
            Class<?> info = Class.forName(className);
            htmlOutput = HTTPObject.doDiscovery(info);
        }
        catch (Throwable t) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            t.printStackTrace(ps);
            htmlOutput = "<html><body>HTTPObject.doDiscovery() : EXCEPTION: " + t.getMessage() + "<br/>" + baos.toString() + "</body></html>";
        }
        return htmlOutput;
    }

    public static String doDiscovery(Object obj) {
        return HTTPObject.doDiscovery(obj.getClass());
    }

    public void doGetClassMetadata(StringBuffer sb) {
        HTTPObject.doGetClassMetadata(sb, this.getClass());
    }

    public void doListMethods(StringBuffer sb) {
        HTTPObject.doListMethods(sb, this.getClass());
    }

    public String doDiscovery() {
        String htmlOutput = null;
        try {
            StringBuffer sb = new StringBuffer();
            this.doGetClassMetadata(sb);
            this.doListMethods(sb);
            sb.append("</class>");
            htmlOutput = sb.toString();
        }
        catch (Exception e) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            e.printStackTrace(ps);
            htmlOutput = "<html><body>Class2Xml.doDiscovery() : EXCEPTION: " + e.getMessage() + "<br/>" + baos.toString() + "</body></html>";
        }
        return htmlOutput;
    }

    public boolean get_methodlist(IHTTPContext context, Vector returnTypes, String method, Hashtable parameters) {
        String methodList = null;
        try {
            methodList = this.doDiscovery();
            context.getResponse().setContentType("text/xml");
            PrintWriter pw = context.getResponse().getWriter();
            pw.print(methodList);
            pw.println();
        }
        catch (Exception exception) {}
        return true;
    }

    static {
        Method[] methods = null;
        try {
            Class<?> classInfo = Class.forName("org.apache.xang.net.http.object.IHTTPObject");
            methods = classInfo.getMethods();
        }
        catch (Exception e) {
            System.err.println("HTTPRequestHandler(): EXCEPTION: " + e.getMessage());
        }
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equalsIgnoreCase("dispatch")) {
                paramSignature = methods[i].getParameterTypes();
                break;
            }
            ++i;
        }
    }
}

