/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.net.http.object.impl;

import FESI.Exceptions.EcmaScriptException;
import FESI.jslib.JSException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xang.net.http.object.IHTTPContext;
import org.apache.xang.net.http.object.impl.HTTPObject;
import org.apache.xang.net.http.object.impl.HTTPScriptContext;
import org.apache.xang.scriptEngine.EngineFactory;
import org.apache.xang.scriptEngine.IEngine;
import org.apache.xang.util.TextUtil;

public class HTTPScriptedObject
extends HTTPObject {
    public static final String ON_ERROR_TAG = "onError";
    public static final String ERROR_TAG = "error";
    public static final String CONTEXT_TAG = "context";
    public static final String RETURN_TYPES_TAG = "returnTypes";
    public static final String METHOD_TAG = "method";
    public static final String PARAMETERS_TAG = "parameters";
    public static final String APP_TAG = "app";
    public static final String[] FESI_EXTENSIONS = new String[]{"FESI.Extensions.BasicIO", "FESI.Extensions.JavaAccess"};
    protected int scriptType = -1;
    public static final String RCS_STRING = "$Workfile: HTTPScriptedObject.java $ $Revision: 1.3 $";

    protected void dumpLine(PrintWriter os, String script, int lineNumber) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new StringBufferInputStream(script)));
        int i = 0;
        try {
            String line;
            i = 0;
            while (i < lineNumber - 1) {
                line = reader.readLine();
                os.write(TextUtil.encodeToHTML(line));
                os.write("\n");
                ++i;
            }
            os.write("<b>");
            line = reader.readLine();
            if (line != null) {
                os.write(TextUtil.encodeToHTML(line));
            }
            os.write("\n");
            os.write("</b>");
            while ((line = reader.readLine()) != null) {
                os.write(TextUtil.encodeToHTML(line));
                os.write("\n");
            }
        }
        catch (IOException iOException) {}
    }

    public boolean dispatch(IHTTPContext context, Vector returnTypes, String method, Hashtable parameters) {
        if (!this.dispatchToScript(context, returnTypes, method, parameters)) {
            return HTTPObject.dispatchToObject(this, context, returnTypes, method, parameters);
        }
        return true;
    }

    public boolean dispatchToScript(IHTTPContext context, Vector returnTypes, String method, Hashtable parameters) {
        HTTPScriptContext scriptContext = new HTTPScriptContext(context, returnTypes, method, parameters);
        String eventName = this.getEventName(context, parameters);
        String function = this.loadHandler(eventName);
        String scriptLanguage = this.loadHandlerType(eventName);
        if (function == null || function.length() < 1) {
            return false;
        }
        String script = this.loadScript(scriptLanguage);
        if (script == null) {
            this.reportNoScript(scriptContext.context);
            return false;
        }
        if (scriptLanguage != null || this.scriptType == -1) {
            this.scriptType = EngineFactory.scriptType(scriptLanguage);
        }
        IEngine engine = EngineFactory.createEngine(this.scriptType);
        engine.addNamedObject(CONTEXT_TAG, scriptContext.context);
        engine.addNamedObject(METHOD_TAG, scriptContext.method);
        engine.addNamedObject(RETURN_TYPES_TAG, scriptContext.returnTypes);
        engine.addNamedObject(PARAMETERS_TAG, scriptContext.parameters);
        engine.addNamedObject(APP_TAG, this);
        this.initSourceContext(engine);
        engine.addScript(script);
        if (!engine.run(function)) {
            Exception throwable = engine.getLastError();
            if (throwable instanceof JSException) {
                if (!this.onError((Throwable)((JSException)throwable), scriptContext)) {
                    this.reportJSException((JSException)throwable, context, eventName, script);
                }
            } else if (throwable instanceof Exception) {
                if (!this.onError(throwable, scriptContext)) {
                    this.reportException(throwable, context, eventName);
                }
            } else if (!this.onError(throwable, scriptContext)) {
                this.reportThrowable(throwable, context, eventName);
            }
        }
        return true;
    }

    public boolean dispatchErrorToScript(Throwable error, HTTPScriptContext scriptContext) {
        String eventName = ON_ERROR_TAG;
        String function = this.loadHandler(eventName);
        String scriptLanguage = this.loadHandlerType(eventName);
        if (function == null || function.length() < 1) {
            return false;
        }
        String script = this.loadScript(scriptLanguage);
        if (script == null) {
            return false;
        }
        if (scriptLanguage != null) {
            this.scriptType = EngineFactory.scriptType(scriptLanguage);
        }
        IEngine engine = EngineFactory.createEngine(this.scriptType);
        engine.addNamedObject(CONTEXT_TAG, scriptContext.context);
        engine.addNamedObject(METHOD_TAG, scriptContext.method);
        engine.addNamedObject(RETURN_TYPES_TAG, scriptContext.returnTypes);
        engine.addNamedObject(PARAMETERS_TAG, scriptContext.parameters);
        engine.addNamedObject(ERROR_TAG, error);
        engine.addNamedObject(APP_TAG, this);
        engine.addScript(script);
        this.initSourceContext(engine);
        if (!engine.run(function)) {
            Exception throwable = engine.getLastError();
            if (throwable instanceof JSException) {
                if (!this.onError((Throwable)((JSException)throwable), scriptContext)) {
                    this.reportJSException((JSException)throwable, scriptContext.context, eventName, script);
                }
            } else if (throwable instanceof Exception) {
                if (!this.onError(throwable, scriptContext)) {
                    this.reportException(throwable, scriptContext.context, eventName);
                }
            } else if (!this.onError(throwable, scriptContext)) {
                this.reportThrowable(throwable, scriptContext.context, eventName);
            }
        }
        return true;
    }

    public void initSourceContext(IEngine engine) {
    }

    public String loadHandler(String eventName) {
        return null;
    }

    public String loadScript(String language) {
        return null;
    }

    public String loadHandlerType(String function) {
        return null;
    }

    public boolean onError(Throwable error, HTTPScriptContext scriptContext) {
        return this.dispatchErrorToScript(error, scriptContext);
    }

    protected void reportJSException(JSException jsException, IHTTPContext context, String eventName, String script) {
        int lineNumber = 0;
        String message = jsException.getMessage();
        Throwable eOriginal = jsException.getOriginatingException();
        if (eOriginal instanceof EcmaScriptException) {
            EcmaScriptException ecmaScriptException = (EcmaScriptException)eOriginal;
            lineNumber = ecmaScriptException.getLineNumber();
        } else {
            message = String.valueOf(eOriginal.getClass().getName()) + " caused a " + message;
        }
        this.report((Throwable)jsException, context, eventName, message);
        PrintWriter out = this.getWriter(context);
        out.write("<pre>");
        this.dumpLine(out, script, lineNumber);
        out.write("</pre>");
    }

    protected void reportException(Exception exception, IHTTPContext context, String eventName) {
        this.report(exception, context, eventName, exception.getMessage());
    }

    protected void reportThrowable(Throwable throwable, IHTTPContext context, String eventName) {
        this.report(throwable, context, eventName, throwable.getMessage());
    }

    protected void report(Throwable throwable, IHTTPContext context, String eventName, String message) {
        PrintWriter out = this.getWriter(context);
        out.write("<html><body>");
        out.write("<h2>System error</h2>");
        if (eventName != null) {
            out.write("Error in handler for '" + eventName + "'");
        }
        out.write("<pre>");
        if (message != null) {
            out.write(message);
        }
        out.write("</pre></body></html>");
        out.write("<!--\n");
        throwable.printStackTrace(out);
        out.write("\n-->");
        out.flush();
    }

    protected void reportNoScript(IHTTPContext context) {
        try {
            context.getResponse().sendError(404, "Unable to find script.");
        }
        catch (Exception exception) {}
    }

    protected String toMixedCase(String value) {
        String s = value;
        s = s.toLowerCase();
        s = String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1, s.length());
        return s;
    }

    protected String getEventName(IHTTPContext context, Hashtable parameters) {
        String function = "on";
        String s = this.toMixedCase(context.getRequest().getMethod());
        function = String.valueOf(function) + s;
        s = context.getRequest().getMethod();
        if (parameters.get("do:method") != null) {
            function = String.valueOf(function) + this.toMixedCase((String)parameters.get("do:method"));
        }
        return function;
    }

    PrintWriter getWriter(IHTTPContext context) {
        try {
            return context.getResponse().getWriter();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

