// scan token helper class for progressive parsing
%include "xercesc/framework/XMLPScanToken.hpp"
%include "xercesc/framework/psvi/PSVIHandler.hpp"

%include "xercesc/sax/Parser.hpp"
%include "xercesc/parsers/AbstractDOMParser.hpp"
%include "xercesc/parsers/XercesDOMParser.hpp"
%include "xercesc/parsers/SAXParser.hpp"

//
// define the exceptions for SAX2XMLReader
//
%define SAXEXCEPTION(method)
%exception method {
    try {
        $action
    } 
    catch (const XMLException& e)
        {
	    makeXMLException(e);
            goto fail;
        }
    catch (const SAXNotSupportedException& e)
	{
	    makeSAXNotSupportedException(e);
            goto fail;
	}
    catch (const SAXNotRecognizedException& e)
	{
	    makeSAXNotRecognizedException(e);
            goto fail;
	}
    catch (...)
        {
            SWIG_croak("Handling Unknown exception");
            goto fail;
        }
}
%enddef

SAXEXCEPTION(XERCES_CPP_NAMESPACE::SAX2XMLReader::getFeature)
SAXEXCEPTION(XERCES_CPP_NAMESPACE::SAX2XMLReader::setFeature)
SAXEXCEPTION(XERCES_CPP_NAMESPACE::SAX2XMLReader::setProperty)
SAXEXCEPTION(XERCES_CPP_NAMESPACE::SAX2XMLReader::getProperty)

%include "xercesc/sax2/SAX2XMLReader.hpp"
%include "xercesc/sax2/XMLReaderFactory.hpp"

