/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.net.http.object.impl.auth.certificate;

import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.apache.xang.net.http.object.IHTTPAuthorizationInfo;
import org.apache.xang.net.http.object.impl.auth.IHTTPAuthorizationHandler;
import org.apache.xang.net.http.object.impl.auth.IHTTPCertAuthorizationConstants;

public class CertificateHandler
implements IHTTPAuthorizationHandler,
IHTTPCertAuthorizationConstants {
    private static final String BASE_PACKAGE_NAME = "org.apache.xang.net.http.object.impl.auth.certificate.";
    Hashtable handlers = new Hashtable();
    public static final String RCS_STRING = "$Workfile: CertificateHandler.java $ $Revision: 1.2 $";

    void trace(String s) {
        System.out.println(s);
    }

    protected IHTTPAuthorizationHandler acquireHandlerForHeader(String header) {
        header = header.toLowerCase();
        String className = BASE_PACKAGE_NAME + header + ".AuthHandler";
        return this.acquireHandler(className);
    }

    protected IHTTPAuthorizationHandler acquireHandler(String className) {
        IHTTPAuthorizationHandler authHandler = null;
        authHandler = (IHTTPAuthorizationHandler)this.handlers.get(className);
        if (authHandler != null) {
            return authHandler;
        }
        try {
            Class<?> authClass = Class.forName(className);
            if (authClass == null) {
                return null;
            }
            authHandler = (IHTTPAuthorizationHandler)authClass.newInstance();
            if (authHandler == null) {
                return null;
            }
        }
        catch (Exception e) {
            this.trace("CertificateHandler.acquireHandler(): EXCEPTION: unable to load class [" + className + "]" + e.getMessage());
            return null;
        }
        this.handlers.put(className, authHandler);
        return authHandler;
    }

    public String getHeaderToUse(HttpServletRequest request) {
        int i = 0;
        while (i < IHTTPCertAuthorizationConstants.certTypes.length) {
            if (request.getHeader(IHTTPCertAuthorizationConstants.certTypes[i]) != null) {
                return IHTTPCertAuthorizationConstants.certTypes[i];
            }
            ++i;
        }
        return null;
    }

    public IHTTPAuthorizationInfo getAuthInfo(String credentials) {
        return null;
    }

    public IHTTPAuthorizationInfo getAuthInfo(HttpServletRequest request) {
        IHTTPAuthorizationInfo authInfo = null;
        String header = this.getHeaderToUse(request);
        IHTTPAuthorizationHandler authHandler = this.acquireHandlerForHeader(header);
        if (authHandler != null) {
            authInfo = authHandler.getAuthInfo(request.getHeader(header));
            this.trace("CertificateHandler.getAuthInfo(): INFO: ");
            if (authInfo != null) {
                this.trace("Domain: " + authInfo.getAuthDomain());
                this.trace("Username: " + authInfo.getAuthUsername());
                this.trace("Password: " + authInfo.getAuthPassword());
            }
        }
        return authInfo;
    }

    public boolean canService(HttpServletRequest request) {
        if (request.getHeader(IHTTPCertAuthorizationConstants.certTypes[0]) != null) {
            return true;
        }
        if (request.getHeader(IHTTPCertAuthorizationConstants.certTypes[1]) != null) {
            return true;
        }
        if (request.getHeader(IHTTPCertAuthorizationConstants.certTypes[2]) != null) {
            return true;
        }
        return request.getHeader(IHTTPCertAuthorizationConstants.certTypes[3]) != null;
    }
}

