/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.xap.xml;

import org.apache.xang.xap.XapDebug;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.framework.XMLParser;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DynamicDocumentParser
extends DOMParser {
    private DocumentImpl doc;

    public DynamicDocumentParser(DocumentImpl doc) {
        this.doc = doc;
        try {
            this.setDocumentClassName("org.apache.xang.xap.xml.DynamicDocument");
        }
        catch (Exception exception) {}
    }

    public static void trace(String s) {
        XapDebug.out(s);
    }

    public Document acquireDocument() {
        if (this.doc != null) {
            return this.doc;
        }
        try {
            if (this.getDocumentClassName().equals("org.apache.xerces.dom.DocumentImpl")) {
                this.fDocumentImpl = new DocumentImpl(this.getFeature("domx/grammar-access"));
                this.fDocument = this.fDocumentImpl;
                this.fDocumentImpl.setErrorChecking(false);
            } else {
                try {
                    Class<?> documentClass = Class.forName(this.getDocumentClassName());
                    this.fDocument = (Document)documentClass.newInstance();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        return this.fDocument;
    }

    public DeferredDocumentImpl acquireDeferredDocument() {
        try {
            return new DeferredDocumentImpl(((XMLParser)this).fStringPool, this.getNamespaces(), this.getFeature("domx/grammar-access"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void startDocument() {
        String documentClassName = null;
        try {
            documentClassName = this.getDocumentClassName();
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("fatal error getting document factory");
        }
        boolean deferNodeExpansion = true;
        try {
            deferNodeExpansion = this.getDeferNodeExpansion();
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("fatal error reading expansion mode");
        }
        if (documentClassName.equals("org.apache.xerces.dom.DocumentImpl") && deferNodeExpansion) {
            boolean nsEnabled = false;
            try {
                nsEnabled = this.getNamespaces();
            }
            catch (SAXException sAXException) {}
            this.fDeferredDocumentImpl = this.acquireDeferredDocument();
            this.fDocument = this.fDeferredDocumentImpl;
            this.fCurrentNodeIndex = this.fDocumentIndex = this.fDeferredDocumentImpl.createDocument();
        } else {
            this.fDocument = this.acquireDocument();
            this.fDocumentImpl = (DocumentImpl)this.fDocument;
            this.fDocumentImpl.setErrorChecking(false);
            this.fCurrentElementNode = this.fDocument;
        }
    }

    public void startDocument(int versionIndex, int encodingIndex, int standAloneIndex) {
        if (versionIndex != -1) {
            ((XMLParser)this).fStringPool.orphanString(versionIndex);
        }
        if (encodingIndex != -1) {
            ((XMLParser)this).fStringPool.orphanString(encodingIndex);
        }
        if (standAloneIndex != -1) {
            ((XMLParser)this).fStringPool.orphanString(standAloneIndex);
        }
        this.startDocument();
    }
}

