/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.xap.xml;

import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xang.xap.xml.DynamicDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DynamicDocData {
    public String sourceFile;
    public Vector nodes = new Vector();
    public Date date;
    public boolean isRoot;

    public DynamicDocData(String sourceFile) {
        this.sourceFile = sourceFile;
        this.setDate();
    }

    public boolean shouldReload() {
        File file = new File(this.sourceFile);
        Date fileDate = new Date(file.lastModified());
        return fileDate.after(this.date);
    }

    protected void reload(Hashtable dynamicDocs) throws Exception {
        Stack<String> includeStack = new Stack<String>();
        includeStack.addElement(this.sourceFile);
        Vector<Element> newNodes = new Vector<Element>();
        int numNodes = this.nodes.size();
        int index = 0;
        while (index < numNodes) {
            Node node = (Node)this.nodes.elementAt(index);
            DynamicDocument importDoc = new DynamicDocument(false, false);
            importDoc.doLoad(this.sourceFile, dynamicDocs, includeStack);
            Element newNode = importDoc.getDocumentElement();
            DynamicDocument.swapNodes(node, newNode);
            newNodes.addElement(newNode);
            ++index;
        }
        this.nodes = newNodes;
        this.setDate();
    }

    protected void setDate() {
        File file = new File(this.sourceFile);
        this.date = new Date(file.lastModified());
    }
}

