/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.net.http.object.impl.auth.http;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.apache.xang.net.http.object.IHTTPAuthorizationInfo;
import org.apache.xang.net.http.object.impl.auth.IHTTPAuthorizationHandler;
import org.apache.xang.util.encoding.BASE64Decoder;

public class HttpHandler
implements IHTTPAuthorizationHandler {
    private static final String BASE_PACKAGE_NAME = "org.apache.xang.net.http.object.impl.auth.http.";
    protected BASE64Decoder decoder = new BASE64Decoder();
    Hashtable handlers = new Hashtable();
    public static final String RCS_STRING = "$Workfile: HttpHandler.java $ $Revision: 1.3 $";

    void trace(String s) {
        System.out.println(s);
    }

    public String decode(String input) {
        try {
            byte[] buffer = this.decoder.process(input);
            if (buffer != null) {
                return new String(buffer);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    protected IHTTPAuthorizationHandler acquireHandlerForType(String type) {
        type = type.toLowerCase();
        String className = BASE_PACKAGE_NAME + type + ".AuthHandler";
        return this.acquireHandler(className);
    }

    protected IHTTPAuthorizationHandler acquireHandler(String className) {
        IHTTPAuthorizationHandler authHandler = null;
        authHandler = (IHTTPAuthorizationHandler)this.handlers.get(className);
        if (authHandler != null) {
            return authHandler;
        }
        try {
            Class<?> authClass = Class.forName(className);
            if (authClass == null) {
                return null;
            }
            authHandler = (IHTTPAuthorizationHandler)authClass.newInstance();
            if (authHandler == null) {
                return null;
            }
        }
        catch (Exception e) {
            this.trace("HttpHandler.acquireHandler(): EXCEPTION: unable to load class [" + className + "]" + e.getMessage());
            return null;
        }
        this.handlers.put(className, authHandler);
        return authHandler;
    }

    public String getAuthType(HttpServletRequest request) {
        String credentials = this.getCredentials(request);
        if (credentials == null) {
            return null;
        }
        String scheme = credentials.substring(0, credentials.indexOf(32));
        return scheme;
    }

    public String getAuthType(String credentials) {
        if (credentials == null) {
            return null;
        }
        String scheme = credentials.substring(0, credentials.indexOf(32));
        return scheme;
    }

    public String getCredentials(HttpServletRequest request) {
        String credentials = request.getHeader("Authorization");
        if (credentials == null) {
            credentials = request.getParameter("do:Authorization");
        }
        return credentials;
    }

    public IHTTPAuthorizationInfo getAuthInfo(String credentials) {
        IHTTPAuthorizationInfo authInfo = null;
        String type = this.getAuthType(credentials);
        IHTTPAuthorizationHandler authHandler = this.acquireHandlerForType(type);
        if (authHandler != null) {
            authInfo = authHandler.getAuthInfo(credentials);
            this.trace("HttpHandler.getAuthInfo(): INFO: ");
            if (authInfo != null) {
                this.trace("Domain: " + authInfo.getAuthDomain());
                this.trace("Username: " + authInfo.getAuthUsername());
                this.trace("Password: " + authInfo.getAuthPassword());
            }
        }
        return authInfo;
    }

    public IHTTPAuthorizationInfo getAuthInfo(HttpServletRequest request) {
        IHTTPAuthorizationInfo authInfo = null;
        String type = this.getAuthType(request);
        IHTTPAuthorizationHandler authHandler = this.acquireHandlerForType(type);
        if (authHandler != null) {
            authInfo = authHandler.getAuthInfo(request);
            this.trace("HttpHandler.getAuthInfo(): INFO: ");
            if (authInfo != null) {
                this.trace("Domain: " + authInfo.getAuthDomain());
                this.trace("Username: " + authInfo.getAuthUsername());
                this.trace("Password: " + authInfo.getAuthPassword());
            }
        }
        return authInfo;
    }

    public boolean canService(HttpServletRequest request) {
        return request.getHeader("Authorization") != null || request.getParameter("do:Authorization") != null;
    }
}

