/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.net.http.object.impl;

import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xang.net.http.object.IHTTPAuthorizationInfo;
import org.apache.xang.net.http.object.IHTTPContext;
import org.apache.xang.net.http.object.IHTTPObject;
import org.apache.xang.net.http.object.IHTTPObjectSystem;
import org.apache.xang.net.http.object.IHTTPRequestHandler;
import org.apache.xang.net.http.object.IHTTPSessionManager;
import org.apache.xang.net.http.object.impl.HTTPObjectServer;
import org.apache.xang.util.ServletUtil;

public class HTTPRequestHandler
implements IHTTPRequestHandler {
    protected static final String URL_NAMESPACE_SEPARATOR = ":";
    protected static final String SUBMETHOD_SEPARATOR = "_";
    String name;
    protected String configFilename;
    String realm;
    String authType;
    IHTTPSessionManager sessionManager = null;
    IHTTPObject rootObject = null;
    public static final String RCS_STRING = "$Workfile: HTTPRequestHandler.java $ $Revision: 1.3 $";

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setAuthType(String type) {
        this.authType = type;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void init(String name, String config, ServletContext ctx) {
        this.name = name;
        this.configFilename = config;
        HTTPRequestHandler.trace("HTTPRequestHandler.init(name,config,ctx): config=" + config);
        try {
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(config);
            props.load(fis);
            fis.close();
            String systemConfig = props.getProperty(String.valueOf(name) + ".system.config");
            if (systemConfig == null || systemConfig.equals("")) {
                ((Hashtable)props).put(String.valueOf(name) + ".system.config", config);
            }
            if ((systemConfig = props.getProperty(String.valueOf(name) + ".session.config")) == null || systemConfig.equals("")) {
                ((Hashtable)props).put(String.valueOf(name) + ".session.config", config);
            }
            this.init(props, ctx);
        }
        catch (Exception e) {
            HTTPRequestHandler.trace("HTTPRequestHandler.init(): 2 EXCEPTION: " + e.getMessage());
            System.err.println("HTTPRequestHandler.init(): 2 EXCEPTION: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void init(String name, String config) {
        this.name = name;
        this.configFilename = config;
        HTTPRequestHandler.trace("HTTPRequestHandler.init(): config=" + config);
        try {
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(config);
            props.load(fis);
            fis.close();
            String systemConfig = props.getProperty(String.valueOf(name) + ".system.config");
            if (systemConfig == null || systemConfig.equals("")) {
                ((Hashtable)props).put(String.valueOf(name) + ".system.config", config);
            }
            if ((systemConfig = props.getProperty(String.valueOf(name) + ".session.config")) == null || systemConfig.equals("")) {
                ((Hashtable)props).put(String.valueOf(name) + ".session.config", config);
            }
            this.init(props);
        }
        catch (Exception e) {
            HTTPRequestHandler.trace("HTTPRequestHandler.init(): 2 EXCEPTION: " + e.getMessage());
            System.err.println("HTTPRequestHandler.init(): 2 EXCEPTION: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean canService(IHTTPContext context) {
        return true;
    }

    public boolean service(IHTTPRequestHandler baseHandler, IHTTPContext context) {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        IHTTPObjectSystem system = this.sessionManager.getSystemForSession(context);
        if (!this.checkAuthInfo(context, system)) {
            return false;
        }
        try {
            IHTTPObject root = null;
            String path = ServletUtil.getPathInfo(context);
            Vector ids = HTTPObjectServer.getPathParts(path);
            String method = HTTPRequestHandler.getCommand(request);
            Hashtable parameters = HTTPRequestHandler.getParameters(request);
            Vector returnTypes = HTTPRequestHandler.getReturnTypes(request, parameters);
            root = this.getRootObject(system);
            if (root != null) {
                this.service(context, root, ids, returnTypes, method, parameters);
            } else {
                response.sendError(404);
            }
            context = null;
        }
        catch (Exception e) {
            HTTPRequestHandler.trace("HTTPRequestHandler.service(): EXCEPTION: " + e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    public boolean checkAuthInfo(IHTTPContext context, IHTTPObjectSystem system) {
        IHTTPAuthorizationInfo authInfo = context.getAuthInfo();
        if (!this.sessionManager.isAcceptable(authInfo) && system == null) {
            HTTPRequestHandler.trace("Requesting " + this.getAuthType() + " authorization for " + this.getRealm());
            HttpServletResponse response = context.getResponse();
            HTTPRequestHandler.sendAuthenticate(response, this.getAuthType(), this.getRealm());
            return false;
        }
        return true;
    }

    public boolean service(IHTTPContext context, IHTTPObject root, Vector ids, Vector returnTypes, String method, Hashtable parameters) {
        IHTTPObject child = null;
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        child = root.getChild(ids, 0);
        if (child != null) {
            if (!child.dispatch(context, returnTypes, method, parameters)) {
                HTTPRequestHandler.trace("HTTPRequestHandler.dispatch(): WARNING: child.dispatch failed. Method='" + method + "'");
                return false;
            }
        } else {
            try {
                response.sendError(404);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    protected static void trace(String s) {
        System.out.println(s);
    }

    protected void init(Properties props, ServletContext ctx) {
        this.realm = props.getProperty(String.valueOf(this.name) + ".system.realm");
        if (this.realm == null || this.realm.equals("")) {
            HTTPRequestHandler.trace("SecureHTTPRequestHandler.init(): ERROR: No realm specified.");
        }
        this.authType = props.getProperty(String.valueOf(this.name) + ".system.authType");
        if (this.realm == null || this.realm.equals("")) {
            this.authType = "Basic";
        }
        String sessionMgrClass = props.getProperty(String.valueOf(this.name) + ".session.classname");
        String sessionConfig = props.getProperty(String.valueOf(this.name) + ".session.config");
        String systemClass = props.getProperty(String.valueOf(this.name) + ".system.classname");
        try {
            Class<?> managerClass = Class.forName(sessionMgrClass);
            this.sessionManager = (IHTTPSessionManager)managerClass.newInstance();
            HTTPRequestHandler.trace("HTTPRequestHandler.Initializing session manager with servlet context");
            this.sessionManager.init(this.name, sessionConfig, ctx);
        }
        catch (Exception e) {
            HTTPRequestHandler.trace("HTTPRequestHandler.init(): EXCEPTION: " + e.getMessage());
            System.err.println("HTTPRequestHandler.init(): EXCEPTION: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessError a) {
            HTTPRequestHandler.trace("HTTPRequestHandler.init(): EXCEPTION: Incompatible class change detected. " + a.getMessage());
            System.err.println("HTTPRequestHandler.init(): EXCEPTION: Incompatible class change detected. " + a.getMessage());
            a.printStackTrace();
        }
    }

    protected void init(Properties props) {
        this.realm = props.getProperty(String.valueOf(this.name) + ".system.realm");
        if (this.realm == null || this.realm.equals("")) {
            HTTPRequestHandler.trace("SecureHTTPRequestHandler.init(): ERROR: No realm specified.");
        }
        this.authType = props.getProperty(String.valueOf(this.name) + ".system.authType");
        if (this.realm == null || this.realm.equals("")) {
            this.authType = "Basic";
        }
        String sessionMgrClass = props.getProperty(String.valueOf(this.name) + ".session.classname");
        String sessionConfig = props.getProperty(String.valueOf(this.name) + ".session.config");
        String systemClass = props.getProperty(String.valueOf(this.name) + ".system.classname");
        try {
            Class<?> managerClass = Class.forName(sessionMgrClass);
            this.sessionManager = (IHTTPSessionManager)managerClass.newInstance();
            HTTPRequestHandler.trace("HTTPRequestHandler.Initializing session manager");
            this.sessionManager.init(this.name, sessionConfig);
        }
        catch (Exception e) {
            HTTPRequestHandler.trace("HTTPRequestHandler.init(): EXCEPTION: " + e.getMessage());
            System.err.println("HTTPRequestHandler.init(): EXCEPTION: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IllegalAccessError a) {
            HTTPRequestHandler.trace("HTTPRequestHandler.init(): EXCEPTION: Incompatible class change detected. " + a.getMessage());
            System.err.println("HTTPRequestHandler.init(): EXCEPTION: Incompatible class change detected. " + a.getMessage());
            a.printStackTrace();
        }
    }

    protected IHTTPSessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected IHTTPObject getRootObject(IHTTPObjectSystem system) {
        if (system != null) {
            return system.getRoot();
        }
        return null;
    }

    protected static String getCommand(HttpServletRequest request) {
        String cmd = null;
        String[] cmds = request.getParameterValues("do:method");
        if (cmds != null && cmds.length > 0) {
            cmd = cmds[0];
        }
        String method = cmd == null || "".equals(cmd) ? request.getMethod() : String.valueOf(request.getMethod()) + SUBMETHOD_SEPARATOR + cmd;
        return method;
    }

    protected static Hashtable getParameters(HttpServletRequest request) {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        String name = null;
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            if (name == null) continue;
            if (request.getParameter(name) == null) {
                parameters.put(name, "");
                continue;
            }
            parameters.put(name, request.getParameter(name));
        }
        return parameters;
    }

    protected static Vector getReturnTypes(HttpServletRequest request, Hashtable parameters) {
        Vector<String> types = null;
        String accept = (String)parameters.get("do:accept");
        accept = accept == null || accept == "" ? request.getHeader("Accept") : String.valueOf(accept) + "," + request.getHeader("Accept");
        if (accept != null && accept != "") {
            StringTokenizer toker = new StringTokenizer(accept, ",");
            types = new Vector<String>();
            while (toker.hasMoreTokens()) {
                String type = toker.nextToken().trim();
                if (type.length() <= 0) continue;
                types.addElement(type);
            }
        }
        return types;
    }

    public static void sendAuthenticate(HttpServletResponse response, String authType, String realm) {
        response.setHeader("WWW-Authenticate", String.valueOf(authType) + " realm=\"" + realm + "\"");
        response.setStatus(401, "Login required.");
    }
}

