/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.net.http.object.impl;

import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xang.net.http.object.IHTTPRequestHandler;
import org.apache.xang.net.http.object.impl.HTTPContext;

public class HTTPObjectServer
extends HttpServlet {
    private static final String URL_NAMESPACE_SEPARATOR = ":";
    private static final String SUBMETHOD_SEPARATOR = "_";
    protected static Hashtable thePaths = new Hashtable();
    protected ServletConfig servletConfig;
    protected ServletContext servletContext;
    protected Hashtable handlers = new Hashtable();
    protected IHTTPRequestHandler defaultHandler = null;
    public static boolean debug;
    public static final String RCS_STRING = "$Workfile: HTTPObjectServer.java $ $Revision: 1.4 $";

    public void init(ServletConfig cfg) throws ServletException {
        super.init(cfg);
        this.servletConfig = cfg;
        this.servletContext = cfg.getServletContext();
        String filename = cfg.getInitParameter("config");
        try {
            this.init(filename);
        }
        catch (Exception e) {
            HTTPObjectServer.trace("HTTPObjectServer.init(): EXCEPTION: " + e.getMessage());
            System.err.println("HTTPObjectServer.init(): EXCEPTION: " + e.getMessage());
        }
    }

    public void doService(HttpServletRequest request, HttpServletResponse response) {
        this.service(request, response);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) {
        HTTPContext context = new HTTPContext(request, response, this.servletContext);
        response.setStatus(200);
        Enumeration enumeration = this.handlers.elements();
        while (enumeration.hasMoreElements()) {
            IHTTPRequestHandler handler = (IHTTPRequestHandler)enumeration.nextElement();
            if (!handler.canService(context)) continue;
            try {
                handler.service(this.defaultHandler, context);
            }
            catch (Exception e) {
                response.setStatus(500, e.getMessage());
                HTTPObjectServer.trace("HTTPObjectServer.service(): EXCEPTION: " + e.getMessage());
                e.printStackTrace(System.err);
            }
            break;
        }
    }

    protected static void trace(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    protected void init(String filename) {
        try {
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(filename);
            props.load(fis);
            fis.close();
            HTTPContext.initSystem(props);
            int i = 0;
            while (i < 100) {
                String prop = "handler." + i + ".name";
                String name = props.getProperty(prop);
                prop = "handler." + i + ".class";
                String classname = props.getProperty(prop);
                prop = "handler." + i + ".config";
                String config = props.getProperty(prop);
                if (config == null || config.equals("")) {
                    config = filename;
                }
                HTTPObjectServer.trace("HTTPObjectServer.init(): config=" + config + " length=" + config.length());
                prop = "handler." + i + ".default";
                String isDefault = props.getProperty(prop);
                if (name == null || classname == null) break;
                try {
                    Class<?> handlerClass = Class.forName(classname);
                    IHTTPRequestHandler handler = (IHTTPRequestHandler)handlerClass.newInstance();
                    handler.init(name, config, this.servletContext);
                    this.handlers.put(name, handler);
                    if ("true".equalsIgnoreCase(isDefault)) {
                        this.defaultHandler = handler;
                    }
                }
                catch (Exception e) {
                    HTTPObjectServer.trace("HTTPObjectServer.init(): EXCEPTION: " + e.getMessage());
                    System.err.println("HTTPObjectServer.init(): EXCEPTION: " + e.getMessage());
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (Exception e) {
            HTTPObjectServer.trace("HTTPObjectServer.init(): EXCEPTION: " + e.getMessage());
            System.err.println("HTTPObjectServer.init(): EXCEPTION: " + e.getMessage());
        }
    }

    public static String makeURL(HttpServletRequest request, String host, String path) {
        StringBuffer b = new StringBuffer(128);
        String scheme = request.getScheme().toString();
        String servletPath = request.getServletPath();
        if (path == null || !path.startsWith(scheme)) {
            b.append(scheme).append("://").append(host);
            int port = request.getServerPort();
            if (port != 80 && port != 443) {
                b.append(':').append(port);
            }
            b.append(servletPath);
        }
        if (path != null) {
            if (HTTPObjectServer.isPathRelative(path)) {
                String s = HTTPObjectServer.makePathFromParts(HTTPObjectServer.getPathParts(path), false);
                if (HTTPObjectServer.isFolder(path)) {
                    s = String.valueOf(s) + "/";
                }
                path = s;
            }
            b.append(HTTPObjectServer.encodeSpaces(path));
        }
        return b.toString();
    }

    public static String makeURL(HttpServletRequest request, String path) {
        return HTTPObjectServer.makeURL(request, request.getServerName(), path);
    }

    public static String makeParentURL(HttpServletRequest request, String path) {
        StringBuffer b = new StringBuffer(128);
        String host = request.getServerName();
        String scheme = request.getScheme().toString();
        String servletPath = request.getServletPath();
        if (!path.startsWith(scheme)) {
            b.append(scheme).append("://").append(host);
            int port = request.getServerPort();
            if (port != 80 && port != 443) {
                b.append(':').append(port);
            }
            b.append(servletPath);
        }
        if (path != null) {
            if (HTTPObjectServer.isPathRelative(path)) {
                String s = HTTPObjectServer.makePathFromParts(HTTPObjectServer.getPathParts(path), true);
                if (HTTPObjectServer.isFolder(path)) {
                    s = String.valueOf(s) + "/";
                }
                path = s;
            } else if (!(path = HTTPObjectServer.makePathFromParts(HTTPObjectServer.getPathParts(path), true)).endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            b.append(HTTPObjectServer.encodeSpaces(path));
        }
        return b.toString();
    }

    public static boolean isPathRelative(String sPath) {
        return sPath.indexOf("/.") >= 0 || sPath.indexOf("/..") >= 0;
    }

    public static Vector getPathParts(String sPath) {
        Vector<String> ids = null;
        if (sPath == null) {
            return new Vector();
        }
        ids = (Vector<String>)thePaths.get(sPath);
        if (ids != null) {
            return ids;
        }
        ids = new Vector<String>();
        StringTokenizer toker = new StringTokenizer(sPath, "/");
        while (toker.hasMoreTokens()) {
            String id = toker.nextToken();
            if (".".equals(id)) continue;
            if ("..".equals(id)) {
                if (ids.size() > 0) {
                    ids.removeElementAt(ids.size() - 1);
                    continue;
                }
                return null;
            }
            ids.addElement(id);
        }
        thePaths.put(sPath, ids);
        return ids;
    }

    private static String decode(String s) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char chr = s.charAt(i);
            if (chr == '%') {
                if (s.charAt(i + 1) == '%') {
                    buffer.append(chr);
                    ++i;
                } else {
                    int hi = s.charAt(i + 1) - 48;
                    int lo = s.charAt(i + 2) - 48;
                    int val = hi * 16 + lo;
                    buffer.append((char)val);
                    i += 2;
                }
            } else {
                buffer.append(chr);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String makePathFromParts(Vector ids, boolean makeParentPath) {
        String s = new String();
        if (ids != null) {
            String lastPart;
            int n = ids.size();
            if (makeParentPath && (lastPart = (String)ids.elementAt(--n)).startsWith("?")) {
                --n;
            }
            int i = 0;
            while (i < n) {
                s = String.valueOf(s) + "/";
                s = String.valueOf(s) + (String)ids.elementAt(i);
                ++i;
            }
        }
        return s;
    }

    private static String encodeSpaces(String str) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char chr = str.charAt(i);
            if (chr == ' ') {
                buf.append("%20");
            } else {
                buf.append(chr);
            }
            ++i;
        }
        return buf.toString();
    }

    private static boolean isFolder(String s) {
        if (s == null || s.length() < 1) {
            return false;
        }
        return s.endsWith("/") || s.endsWith("..");
    }
}

