/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.xap;

import java.io.FileInputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.xang.net.http.object.IHTTPAuthorizationInfo;
import org.apache.xang.net.http.object.IHTTPContext;
import org.apache.xang.net.http.object.IHTTPObjectSystem;
import org.apache.xang.net.http.object.IHTTPSessionManager;
import org.apache.xang.net.http.object.impl.HTTPObject;
import org.apache.xang.net.http.object.impl.debug.DebugHTTPObjectServer;
import org.apache.xang.xap.XapDebug;
import org.apache.xang.xap.XapSystem;

public class XapSessionManager
extends HTTPObject
implements IHTTPSessionManager {
    String name = "";
    String rootFile = "";
    Date xmlDocDate = new Date();
    Hashtable sessions = new Hashtable();
    public static final String RCS_STRING = "$Workfile: XapSessionManager.java $ $Revision: 1.3 $";

    protected IHTTPObjectSystem createSystem(String rootFile) {
        XapSystem system = new XapSystem(rootFile);
        this.sessions.put(rootFile, system);
        return system;
    }

    protected String getDoc(IHTTPContext context) {
        String path = context.getRequest().getServletPath();
        String realPath = path.startsWith("/servlet/xpages") || path.startsWith("/servlet/xap") || path.startsWith("/servlet/Xap") ? this.rootFile : context.getRequest().getRealPath(path);
        return realPath;
    }

    public IHTTPObjectSystem getSystemForSession(IHTTPContext context) {
        String rootFile = this.getDoc(context);
        IHTTPObjectSystem system = (IHTTPObjectSystem)this.sessions.get(rootFile);
        if (system == null) {
            system = this.createSystem(rootFile);
        }
        return system;
    }

    public void init(String name, String config) {
        this.name = name;
        try {
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(config);
            props.load(fis);
            fis.close();
            this.rootFile = (String)((Hashtable)props).get("Xap.rootFile");
        }
        catch (Exception e) {
            XapDebug.error(e);
        }
    }

    public void init(String name, String config, ServletContext ctx) {
        this.init(name, config);
    }

    public boolean isAcceptable(IHTTPAuthorizationInfo info) {
        return true;
    }

    public static void main(String[] args) {
        int loop = 1;
        DebugHTTPObjectServer server = new DebugHTTPObjectServer(args[0]);
        if (args.length > 1) {
            loop = Integer.parseInt(args[1]);
        }
        int i = 0;
        while (i < loop) {
            server.invoke("GET", "http://debug/servlet/Xap/", "northwind/service", null, null, System.out);
            ++i;
        }
    }
}

