/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xang.util.base64;

public final class Base64 {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 63;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIXBIT = 6;
    private static final int FOURBYTE = 4;
    private static final byte PAD = 61;
    private static byte[] base64Alphabet = new byte[255];
    private static byte[] lookUpBase64Alphabet = new byte[63];

    static {
        int i = 0;
        while (i < 255) {
            Base64.base64Alphabet[i] = -1;
            ++i;
        }
        int i2 = 90;
        while (i2 >= 65) {
            Base64.base64Alphabet[i2] = (byte)(i2 - 65);
            --i2;
        }
        int i3 = 122;
        while (i3 >= 97) {
            Base64.base64Alphabet[i3] = (byte)(i3 - 97 + 26);
            --i3;
        }
        int i4 = 57;
        while (i4 >= 48) {
            Base64.base64Alphabet[i4] = (byte)(i4 - 48 + 52);
            --i4;
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        int i5 = 0;
        while (i5 <= 25) {
            Base64.lookUpBase64Alphabet[i5] = (byte)(65 + i5);
            ++i5;
        }
        int i6 = 26;
        int j = 0;
        while (i6 <= 51) {
            Base64.lookUpBase64Alphabet[i6] = (byte)(97 + j);
            ++i6;
            ++j;
        }
        int i7 = 52;
        int j2 = 0;
        while (i7 <= 61) {
            Base64.lookUpBase64Alphabet[i7] = (byte)(48 + j2);
            ++i7;
            ++j2;
        }
    }

    public byte[] decode(byte[] base64Data) {
        int numberQuadruple = base64Data.length / 4;
        byte[] decodedData = null;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        byte b4 = 0;
        byte marker0 = 0;
        byte marker1 = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        decodedData = new byte[numberQuadruple * 3 + 1];
        int i = 0;
        while (i < numberQuadruple) {
            dataIndex = i * 4;
            marker0 = base64Data[dataIndex + 2];
            marker1 = base64Data[dataIndex + 3];
            b1 = base64Alphabet[base64Data[dataIndex]];
            b2 = base64Alphabet[base64Data[dataIndex + 1]];
            if (marker0 != 61 && marker1 != 61) {
                b3 = base64Alphabet[marker0];
                b4 = base64Alphabet[marker1];
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                decodedData[encodedIndex + 2] = (byte)(b3 << 6 | b4);
            } else if (marker0 == 61) {
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b2 & 0xF) << 4);
                decodedData[encodedIndex + 2] = 0;
            } else if (marker1 == 61) {
                b3 = base64Alphabet[marker0];
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                decodedData[encodedIndex + 2] = (byte)(b3 << 6);
            }
            encodedIndex += 3;
            ++i;
        }
        return decodedData;
    }

    public byte[] encode(byte[] binaryData) {
        int lengthDataBits = binaryData.length * 8;
        int fewerThan24bits = lengthDataBits % 24;
        int numberTriplets = lengthDataBits / 24;
        byte[] encodedData = null;
        encodedData = fewerThan24bits != 0 ? new byte[(numberTriplets + 1) * 4] : new byte[numberTriplets * 4];
        byte k = 0;
        byte l = 0;
        byte b1 = 0;
        byte b2 = 0;
        byte b3 = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        int i = 0;
        i = 0;
        while (i < numberTriplets) {
            dataIndex = i * 3;
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            b3 = binaryData[dataIndex + 2];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            encodedIndex = i * 4;
            encodedData[encodedIndex] = lookUpBase64Alphabet[b1 >> 2];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[b2 >> 4 | k << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l << 2 | b3 >> 6];
            encodedData[encodedIndex + 3] = lookUpBase64Alphabet[b3 & 0x3F];
            ++i;
        }
        dataIndex = i * 3;
        encodedIndex = i * 4;
        if (fewerThan24bits == 8) {
            b1 = binaryData[dataIndex];
            k = (byte)(b1 & 3);
            encodedData[encodedIndex] = lookUpBase64Alphabet[b1 >> 2];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[k << 4];
            encodedData[encodedIndex + 2] = 61;
            encodedData[encodedIndex + 3] = 61;
        } else if (fewerThan24bits == 16) {
            b1 = binaryData[dataIndex];
            b2 = binaryData[dataIndex + 1];
            l = (byte)(b2 & 0xF);
            k = (byte)(b1 & 3);
            encodedData[encodedIndex] = lookUpBase64Alphabet[b1 >> 2];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[b2 >> 4 | k << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l << 2];
            encodedData[encodedIndex + 3] = 61;
        }
        return encodedData;
    }

    static boolean isArrayByteBase64(byte[] arrayOctect) {
        int length = arrayOctect.length;
        if (length == 0) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!Base64.isBase64(arrayOctect[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean isBase64(byte octect) {
        return octect == 61 || base64Alphabet[octect] != -1;
    }
}

